# Subtitle Shifter - Feature List

A running checklist of features for the Subtitle Shifter tool.  
Edit this file as development progresses. Mark completed items with `[x]`.  
Upload this file before starting a new coding round.

---

## 1. Core Functions
- [ ] Load `.srt` subtitle file
- [ ] Shift subtitle times by positive/negative seconds (fractions allowed, e.g. `-1.25`)
- [ ] Save shifted subtitles to new file
- [ ] Default suffix for output (e.g. `_shifted`)

---

## 2. File Handling
- [ ] Remember last used folder
- [ ] Remember last shift value
- [ ] Remember last chosen suffix
- [ ] Ask before overwriting if output file exists
- [ ] Option to overwrite original file directly (no suffix)
- [ ] Batch processing (multiple `.srt` files at once)

---

## 3. Naming & Output
- [ ] Customizable suffix (user enters suffix text)
- [ ] Presets for common suffixes (e.g. `_+2s`, `_fix`)
- [ ] Option to set output folder different from input

---

## 4. GUI
- [ ] Tkinter-based interface
- [ ] Browse button for selecting files
- [ ] Drag-and-drop file support
- [ ] Dark mode / theme support
- [ ] Display confirmation of new file path after save
- [ ] Allow resizing / scaling for different screen sizes

---

## 5. Advanced Features (Future Ideas)
- [ ] Shift only selected lines (not entire file)
- [ ] Video preview with shifted subtitles
- [ ] Waveform or timeline view
- [ ] Undo last operation
- [ ] Save & load project/session settings

---

## Notes
- Store user preferences in a JSON config file (`subtitle_shift_config.json`)
- Use only common libraries: `tkinter`, `pysrt`, (`tkinterdnd2` optional for drag-drop)
- Keep code clean and commented
